
import numpy as np


class Tx:
	"""
	Description:
		Class for generating random data sequence
	"""
	def __init__(self, mod):
		"""
		Params:
			mod(str)	: Select modulation. nrz / pam4 / pam8

		"""
		if (mod=='nrz'):
			self.modNum_=2
		elif (mod=='pam4'):
			self.modNum_=4
		elif (mod=='pam8'):
			self.modNum_=8



	def run(self,length):
		"""
		Description:
			Generating random data whose range is -1~1
			i.e) nrz: -1,1  / pam4: -1, -1/3, 1/3, 1 / ...
		Params:
			length(int)	: Length of generating data
		"""
		seq = np.array([],dtype=np.int)
		seq = np.append(seq, np.random.randint(self.modNum_, size=length))
		if 0:
			seq = np.zeros(length)
		elif 0:
			seq = [0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]*int(length/10)
			seq = np.array(seq)
		amp = (self.modNum_-1)/2
		out = (seq-amp)/amp
		return out



if __name__ == '__main__':
	tx= Tx(mod='nrz')
	x=tx.run(10)
	print(x)
